using System;
using Server;
using Server.Gumps;
using Server.Mobiles;

namespace Server.Items
{
	[Flipable( 0x14EF, 0x14F0 )]
	public class MonsterContract : Item
	{
		private string m_type;
		private int reward;
		private int gen;
		private int m_amount;
		private int m_killed;
		
		[CommandProperty( AccessLevel.GameMaster )]
		public string Monster
		{
			get{ return m_type; }
			set{ m_type = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Reward
		{
			get{ return reward; }
			set{ reward = value; }
		}

		[CommandProperty( AccessLevel.GameMaster )]
		public int Gen
		{
			get{ return gen; }
			set{ gen = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int AmountToKill
		{
			get{ return m_amount; }
			set{ m_amount = value; }
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int AmountKilled
		{
			get{ return m_killed; }
			set{ m_killed = value; }
		}
		
		[Constructable]
		public MonsterContract() : base( 0x14EF )
		{
			Movable = true;
			Hue = 5359;
			LootType = LootType.Blessed;
			Gen = Utility.Random( 6 );
			Monster = GetRandomMonster( Gen );
			AmountToKill = Utility.Random( 20 ) + 5;
			Reward = 97 * (Gen + 1) * AmountToKill + 500; //Utility.Random( 150 )
			Name = "Lovecka zakazka: " + AmountToKill + " " + Monster + "s";
			AmountKilled = 0;
		}
		
		[Constructable]
		public MonsterContract( string type, int atk, int gpreward ) : base( 0x14F0 )
		{
			Movable = true;
			Hue = 376;
			LootType = LootType.Blessed;
			Monster = type;
			AmountToKill = atk;
			Reward = gpreward;
			Name = "Lovecka zakazka: " + AmountToKill + " " + Monster + "s";
			AmountKilled = 0;
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if( IsChildOf( from.Backpack ) )
			{
			   if( from.HasGump( typeof(MonsterContractGump) ) )
				  from.CloseGump( typeof(MonsterContractGump) );
            
            from.SendGump( new MonsterContractGump( from, this ) );
			}
			else
			{
				from.SendLocalizedMessage( 1047012 ); // This contract must be in your backpack to use it
			}
		}
		
		public MonsterContract( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
			
			writer.Write( m_type );
			writer.Write( gen );
			writer.Write( reward );
			writer.Write( m_amount );
			writer.Write( m_killed );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
			
			m_type = reader.ReadString();
			gen = reader.ReadInt();
			reward = reader.ReadInt();
			m_amount = reader.ReadInt();
			m_killed = reader.ReadInt();
			LootType = LootType.Blessed;
		}
		
		public string GetRandomMonster( int genre )
		{
			switch ( genre )
			{
				case 0:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Mongbat";
							break;
							case 1:	return "Skeleton";
							break;
							case 2:	return "Headless One";
							break;
							case 3:	return "Eagle";
							break;
							default: return "Eagle";
							break;
					}
					break;
				case 1:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Wraith";
							break;
							case 1:	return "Zombie";
							break;
							case 2:	return "Bogling";
							break;
							case 3:	return "Alligator";
							break;
							default: return "Zombie";
							break;
					}
					break;
				case 2:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Giant Spider";
							break;
							case 1:	return "Earth Elemental";
							break;
							case 2:	return "Ettin";
							break;
							case 3:	return "Harpy";
							break;
							default: return "Harpy";
							break;
					}
					break;
				case 3:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Wyvern";
							break;
							case 1:	return "Ogre";
							break;
							case 2:	return "Gargoyle";
							break;
							case 3:	return "Drake";
							break;
							default: return "Ogre";
							break;
					}
					break;
				case 4:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Ophidian Matriarch";
							break;
							case 1:	return "Arctic Ogre Lord";
							break;
							case 2:	return "Lich";
							break;
							case 3:	return "Wanderer of the Void";
							break;
							default: return "Lich";
							break;
					}
					break;
				case 5:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Ancient Wyrm";
							break;
							case 1:	return "Dragon";
							break;
							case 2:	return "White Wyrm";
							break;
							case 3:	return "Phoenix";
							break;
							default: return "Dragon";
							break;
					}
					break;
				default:
					switch (Utility.Random( 4 ) )
					{
							case 0:	return "Ancient Wyrm";
							break;
							case 1:	return "Dragon";
							break;
							case 2:	return "White Wyrm";
							break;
							case 3:	return "Phoenix";
							break;
							default: return "Dragon";
							break;
					}
					break;
			}
		}
	}
}
